/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public final class TableDescriptions {
    private static final String TABLE_DESC_FILE = "MckoiDB.desc";
    private File table_desc_file;
    private File temp_desc_file;
    private File backup_file;
    private HashMap table_descriptions;

    public TableDescriptions(File database_path) {
        this.table_desc_file = new File(database_path, TABLE_DESC_FILE);
        this.temp_desc_file = new File(database_path, "MckoiDB.desc.temp");
        this.backup_file = new File(database_path, "MckoiDB.desc.bak");
        this.clear();
    }

    public boolean exists() {
        return this.table_desc_file.exists() && !this.table_desc_file.isDirectory();
    }

    public void load() throws IOException {
        if (this.table_desc_file.exists()) {
            DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.table_desc_file)));
            int ver = din.readInt();
            int table_count = din.readInt();
            for (int i = 0; i < table_count; ++i) {
                DataTableDef table_desc = DataTableDef.read(din);
                String name = table_desc.getName();
                this.table_descriptions.put(name, table_desc);
            }
            din.close();
        }
    }

    public void save() throws IOException {
        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.temp_desc_file)));
        dout.writeInt(1);
        String[] table_list = this.getTableList();
        dout.writeInt(table_list.length);
        for (int i = 0; i < table_list.length; ++i) {
            ((DataTableDef)this.table_descriptions.get(table_list[i])).write(dout);
        }
        dout.flush();
        dout.close();
        this.backup_file.delete();
        this.table_desc_file.renameTo(this.backup_file);
        this.temp_desc_file.renameTo(this.table_desc_file);
    }

    void add(DataTableDef table) throws IOException {
        this.table_descriptions.put(table.getName(), table);
    }

    void remove(String name) throws IOException {
        this.table_descriptions.remove(name);
    }

    public String[] getTableList() {
        Set keys = this.table_descriptions.keySet();
        Object[] all_keys = keys.toArray(new String[keys.size()]);
        Arrays.sort(all_keys);
        return all_keys;
    }

    void clear() {
        this.table_descriptions = new HashMap(150, 0.5f);
    }

    public DataTableDef getDef(String table_name) {
        return (DataTableDef)this.table_descriptions.get(table_name);
    }
}

